#!/bin/bash

# Goaml of this scirpt is to copy Here_named.rules to /etc/udev/rules.d
######################################################
rulefile=20-usb-serial_kungfu32.rules
srcdir=.
tgtdir=/etc/udev/rules.d

######################################################
# Test if the rule is already installed
if [ -f "$tgtdir/$rulefile" ]; then
	echo "An udev rule for kungfu32 already exists"
else
	# Test if GKSUDO exists		
	if type -p gksudo > /dev/null; then
		gksudo_exist=true
	fi
	###########################
    if [ -d "$tgtdir" ]; then 
	    cpcmd="cp $srcdir/$rulefile $tgtdir"
	    if [ $gksudo_exist ] && [[ -n "$DISPLAY" ]]; then
		    gksudo "$cpcmd" -D "Install Udev rule for kungfu32"
	    else
		    sudo $cpcmd
	    fi
 	    cpcmd="chmod 666 $tgtdir/$rulefile"
	    sudo $cpcmd
	else
	    echo "Cannot find the target directory \"$tgtdir\""
	fi
	###########################
fi
######################################################
if [ -f "$tgtdir/$rulefile" ]; then
	echo "-- Udev rule for kungfu32 installation done --"
	echo
	exit 0;
else
    echo "-- Udev rule installation failed --"
	echo "Please manually copy $srcdir/$rulefile to the udev rules directory $tgtdir"
	echo
	exit 1;
fi
######################################################
